//---------- Copyright 2025 FozerGames. ----------
//Thank you for creating mods for the game :-)

// Если в настройках игры отключена растительность, то скрипт TressDisabler.cs отключает все объекты, которые её содержат.
// If vegetation is disabled in the game settings, the TressDisabler.cs script disables all objects that contain it.
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
[DefaultExecutionOrder(-100)]
public class TressDisabler : MonoBehaviour
{
    [Space(20)]
    [Tooltip("List of tree objects")]
    public List<GameObject> tressObjects = new List<GameObject>();
    [Tooltip("Enable or disable tree objects (only for test)")]
    public bool isTressEnabled = true;
    void Start()
    {
        foreach (var item in tressObjects)
        {
            item.SetActive(isTressEnabled);
        }
    }
}
